const getInput = labelText => {
  return Array.from(document.querySelector('.answer').querySelectorAll('div'))
    .find(div => div.querySelector('label').innerText.includes(labelText))
    ?.querySelector('input')
}

const solve = () => {
  const question = document.querySelector('.qtext').innerText
  const correctAnswer = answers.filter(answer =>
    question.startsWith(answer.question)
  )

  if (!correctAnswer.length || correctAnswer.every(({ answer }) => !answer))
    return null

  if (correctAnswer[0].type === 'text') {
    document.querySelector('input[type=text]').value = correctAnswer[0].answer
  } else {
    correctAnswer
      .map(({ answer }) => getInput(answer))
      .filter(input => input)[0].checked = true
  }

  document.querySelector('[name=next]').click()

  return true
}

chrome.runtime.onMessage.addListener(async function (
  request,
  sender,
  sendResponse
) {
  let data = undefined

  switch (request.command) {
    case 'solve':
      if (!solve()) {
        const popup = document.createElement('div')

        const heading = document.createElement('h2')
        const headingText = document.createTextNode('Error')
        heading.appendChild(headingText)

        const msg = document.createElement('p')
        const msgText = document.createTextNode('Unknown Question')
        msg.appendChild(msgText)

        popup.appendChild(heading)
        popup.appendChild(msgText)

        popup.style.position = 'fixed'
        popup.style.top = '2rem'
        popup.style.left = '50%'
        popup.style.transform = 'translateX(-50%)'
        popup.style.zIndex = '1000'
        popup.style.background = '#f76754'
        popup.style.padding = '1rem 3rem'
        popup.style.borderRadius = '1rem'
        popup.style.textAlign = 'center'
        popup.style.color = 'black'

        const element = document.querySelector('body')
        element.appendChild(popup)
      }
      break

    case 'record':
      recordAnswer()
      break

    case 'recordRes':
      data = await recordResult()
      break

    case 'finishPractice':
      finishPractice()
      break

    default:
      console.log('ho')
      break
  }

  sendResponse({ result: 'success', data })
})

const recordAnswer = () => {
  const question = document.querySelector('.qtext').querySelector('p').innerText

  const answer = Array.from(
    document.querySelector('.answer').querySelectorAll('div')
  )
    .find(div => div.querySelector('input').checked)
    .querySelector('label')
    .innerText.replace(/^[abcdefg]\.\ /, '')

  return {
    msg: 'copied to clipboard',
    clipboard: `{question: "${question}", answer: "${answer}"},`,
  }
}

const recordResult = async () => {
  const answers = Array.from(document.querySelectorAll('.que')).map(que => {
    let type = ''
    let answer = null

    const answerInput = que.querySelector('.correct')

    if (answerInput && answerInput.type === 'text') {
      answer = answerInput.value
      type = 'text'
    } else if (answerInput) {
      answer = answerInput
        .querySelector('label')
        .innerText.replace(/^[abcdefg]\.\ /, '')
      type = 'select'
    }

    return {
      question: que.querySelector('.qtext').innerText,
      type,
      answer: answer,
    }
  })

  const res = JSON.stringify(answers)

  return { msg: 'copied to clipboard', clipboard: res }
}

const finishPractice = async () => {
  const setFinished = JSON.parse(
    document
      .querySelectorAll('script')[7]
      .innerText.replace('\n//<![CDATA[\nvar H5PIntegration = ', '')
      .replace(';\n//]]>\n', '')
  ).ajax.setFinished

  if (!setFinished) return

  await fetch(setFinished, {
    credentials: 'include',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
    },
    method: 'POST',
    body: 'contentId=216&score=7&maxScore=7&opened=1673959118&finished=1673959456',
    mode: 'cors',
  })

  window.history.back()
}

const answers = [
  ///  Digital citizenship

  {
    question:
      'Every time you upload something to the Internet or post something to social media you are adding to your digital footprint.',
    answer: 'True',
  },
  {
    question: 'Only you are responsible for your digital footprint.',
    answer: 'False',
  },
  {
    question:
      'In the UK, the principles of free speech mean you are allowed to post any opinions without facing possible legal consequences.',
    answer: 'False',
  },
  {
    question:
      "It is acceptable to post inappropriate comments as long as it is 'only banter' and you keep your posts to private groups.",
    answer: 'False',
  },
  {
    question:
      'The digital footprint you make when you are young can have a serious impact on you later in life. It can even make you lose your job when you are older.',
    answer: 'True',
  },
  {
    question:
      'Which of the following information should you avoid adding to social media as it can be used by criminals to steal your identity and even your money?',
    answer: 'All of the above',
  },
  {
    question:
      "If you have your social media settings set to 'private' then nothing you post can ever become publicly available.",
    answer: 'False',
  },
  {
    question:
      'You should spring clean your social media every few weeks / months to make sure it shows you in as positive a light as possible. What should you do with posts that do not reflect well on you?',
    answer: 'Delete them',
  },
  {
    question:
      'Having a digital footprint is always a bad thing. You should avoid having one.',
    answer: 'False',
  },
  {
    question: 'What is the minimum age limit for using Snapchat and Instagram?',
    answer: '13',
  },
  {
    question: 'What is the minimum age limit for using WhatsApp?',
    answer: '16',
  },
  {
    question:
      'When you make an Instagram account, your account is automatically set to...',
    answer: 'Public (your images can be seen by anybody)',
  },
  {
    question:
      "According to a survey by the Royal Society for Public Health, which social media platform causes the most damage to young people's mental health?\n",
    answer: 'Instagram',
  },
  {
    question:
      'Which social media app is often used for bullying because abusive messages posted automatically disappear shortly after they are seen?',
    answer: 'Snapchat',
  },
  {
    question:
      'The Snap Map feature in Snapchat is dangerous because it shows people where you are. To turn this off you should select...',
    answer: 'Ghost mode',
  },
  {
    question:
      "Many social media tools include features which are deliberately designed to be ********* and to keep you coming back over and over again. An example is 'Snap Streaks'. \n",
    answer: 'addictive',
    type: 'text',
  },
  {
    question:
      "If you use the Google Chrome browser you can install an extension called 'Trusted News' which aims to help you spot fake or suspicious news\n",
    answer: 'True',
  },
  {
    question:
      'Social media influencers are not allowed to be paid for recommending things or promoting products.',
    answer: 'False',
  },

  /// Nudes, pornography and sexual harassment

  {
    question:
      'As soon as you send a nude on to somebody else you lose all control of what happens to your image / video from that point forward.\n',
    answer: 'True',
  },
  {
    question:
      'In the Ofsted review, what proportion of girls said they are regularly put under pressure to share nudes of themselves?\n',
    answer: '80%',
  },
  {
    question:
      'Being pressured to share naked images and videos of yourself should be seen as an accepted part of growing up.\n',
    answer: 'False',
  },
  {
    question:
      'A healthy, balanced relationship is one where there is an equality of the rights and feelings of both individuals.\n',
    answer: 'True',
  },
  {
    question:
      'Which of the following is not an appropriate response if you find yourself being pressured to send nudes to somebody?',
    answer: 'Send just a top-half image, not a full body image.',
  },
  {
    question:
      "The crime of \nAnswer\n is when criminals trick somebody into sending a nude or sexual video, and then blackmail that person. They threaten to share the images / videos publicly and send it to the person's contacts unless a sum of money is paid.",
    answer: 'sextortion',
    type: 'text',
  },
  {
    question:
      'If you have sent a nude or sexual video to somebody and you are now being blackmailed for money, the best thing to do is to quickly pay before the price goes up or they share the images online.',
    answer: 'False',
  },
  {
    question:
      'Is it legal to take a naked picture of yourself and share it with somebody else if you are under 18?',
    answer: 'No, this is illegal.',
  },
  {
    question:
      'Is it legal to take a naked picture of yourself and share it with somebody else if you are over 18?',
    answer:
      'Yes, this is legal as long as the person receiving the image is also over 18.',
  },
  {
    question:
      'Somebody under 18 has sent you a naked picture of themselves. Is it legal for you to keep the image?',
    answer: 'No, this is illegal.',
  },
  {
    question:
      'Is it legal for you to pressure somebody under 18 to send you a naked picture of themselves?',
    answer: 'No, this is always illegal.',
  },
  {
    question:
      'Somebody under 18 has sent you a naked picture of themselves. Is it legal for you to then share that with other people?',
    answer: 'No, this is always illegal.',
  },
  {
    question:
      'Young people that get reported to the police for sending nudes will most likely be charged with breaking the law.',
    answer: 'False',
  },
  {
    question:
      "You can only be prosecuted under the 'Revenge Porn' laws if you used to be in relationship with somebody else and have released their nudes in revenge for something that has happened between you.",
    answer: 'False',
  },
  {
    question:
      "The ‘Revenge Porn’ laws are changing so that threatening to release somebody's nudes will soon become illegal, even if you only threaten it but never actually do it.\n",
    answer: 'True',
  },
  {
    question: 'Complete the quote from the Ofsted review:',
    answer: 'collection',
    type: 'text',
  },
  {
    question:
      'What is the name of the online service you can use which will find your nudes on the Internet and have them removed?\n',
    answer: 'Report-Remove',
  },
  {
    question:
      'Which of the following is NOT a common impact for people who have created and shared nudes?',
    answer: 'Increased risk of viruses on computers',
  },
  {
    question:
      "A very important word in this module is '\nAnswer\n'. This means that a person gives permission for something to happen.",
    answer: 'consent',
    type: 'text',
  },
  {
    question:
      'Pornography is a reliable and realistic source of guidance on what a normal and healthy sexual relationship should look like.',
    answer: 'False',
  },
  {
    question:
      'Sending or showing somebody pornography without their permission to do so can be classed as sexual harassment.',
    answer: 'True',
  },
  {
    question:
      "Giving in to one form of sexual bullying (such as being pressured to share nudes) often makes you vulnerable to a second form of sexual bullying (such as 'slut shaming').",
    answer: 'True',
  },

  /// Cyber-Security

  {
    question: "What is the best definition of a 'data breach'?\n",
    type: 'select',
    answer: 'When confidential data is accessed without permission.',
  },
  {
    question:
      'A report by CybSafe stated that 9 out of 10 cyber breaches are caused by...\n',
    type: 'select',
    answer: 'User error',
  },
  {
    question:
      "It is good cyber-security practice to make long, complex passwords to make them hard to guess and then write them down somewhere so you don't forget them.",
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'It is good cyber-security practice to make one long, complex password and then use that on all systems you need to log in to.',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'When is it best to run any software and system updates on your computers and other devices?',
    type: 'select',
    answer: 'As soon as the updates become available',
  },
  {
    question:
      'What is it essential to do with a computer you have been working on if you are going to leave it unsupervised for a period of time?',
    type: 'select',
    answer: 'Lock the computer (CTRL-ALT-DEL >> Lock) or log off.',
  },
  {
    question:
      'Images and videos that you save on cloud storage could be posted publicly online by somebody else.',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'Which of the following would provide the best security for cloud storage?',
    type: 'select',
    answer: '2-factor authentication',
  },
  {
    question:
      'Using which of the following is most likely to result in you installing a virus on a smartphone?',
    type: 'select',
    answer: 'Third-party app stores',
  },
  {
    question:
      'You can only install anti-virus software on desktop computers and laptops, not on mobile devices like smartphones and tablet computers.',
    type: 'select',
    answer: 'False',
  },

  /// Grooming

  {
    question:
      'Grooming is when somebody tries to gain the ***** of a young person in order to exploit them.',
    type: 'text',
    answer: 'trust',
  },
  {
    question: 'Grooming only happens online.',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      "Many children and young people don't understand that they have been groomed or that what has happened is abuse - they may think the groomer is their friend.\n",
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'According to police figures, on average how many cases of sexual contact with children are made each week?\n',
    type: 'select',
    answer: '120',
  },
  {
    question:
      'According to the NSPCC, how quickly can a groomer successfully groom a young person online?',
    type: 'select',
    answer: '30-45 minutes',
  },
  {
    question: 'Grooming takes place in online games as well as social media.\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'You can tell the age of somebody and whether they are male or female by looking at their profile picture.',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'It is safest if you only talk to people online that you know in real ****.',
    type: 'text',
    answer: 'life',
  },
  {
    question:
      'To stay safe you should check your ******* settings – keep everything set to private / friends only.',
    type: 'text',
    answer: 'privacy',
  },
  {
    question: 'Your choice of profile picture is not very important.',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'What will groomers often use to try to convince young people to not talk to other people about them?\n',
    type: 'select',
    answer: 'Secrets',
  },
  {
    question:
      'You should beware of games of **** - these can start with small things but build to larger and more inappropriate challenges that you would not initially have agreed to.',
    type: 'text',
    answer: 'dare',
  },
  {
    question:
      'If you think you are being groomed, an important first step is to...',
    type: 'select',
    answer: 'Speak to an appropriate adult (e.g. a parent or carer)',
  },
  {
    question:
      'There is a branch of the police that deal with grooming and the sexual exploitation of young people. They can quickly make grooming stop and protect you. What is this branch of the police called?',
    type: 'select',
    answer: 'CEOP',
  },

  /// Health risks

  {
    question:
      'People who use digital devices for long periods of time often get a condition called RSI. This stands for Repetitive Strain ******.',
    type: 'text',
    answer: 'Injury',
  },
  {
    question:
      'If you start feeling soreness or numbness in your fingers or wrist while using a digital device, what should you do?',
    type: 'select',
    answer: 'Take a break',
  },
  {
    question:
      'What is said to be the safe upper sound limit for listening to music through headphones?',
    type: 'select',
    answer: '80 decibels',
  },
  {
    question:
      'It is often said that a computer keyboard is much dirtier and germ-covered than a public toilet seat.\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'What have some parts of the world used to reduce the risk of people walking in front of cars while looking at their smartphones?',
    type: 'select',
    answer: 'Lights in the floor',
  },
  {
    question:
      "Looking down at a tablet or phone for long periods of time can result in headaches and pain in your neck and back. Over time it can even result in permanent damage and a curved hunchback-type spine. This condition is called '**** neck'.\n",
    type: 'text',
    answer: 'Text',
  },
  {
    question:
      'Extended use of digital devices can result in headaches and strained eyes. Eye strain can result in permanent damage and increasing numbers of people are becoming...\n',
    type: 'select',
    answer: 'Short-sighted',
  },
  {
    question:
      'According to a recent study, what proportion of girls who spend more than five hours a day on social media show symptoms of depression?\n',
    type: 'select',
    answer: '40%',
  },
  {
    question:
      'Some scientists believe that digital devices are making it harder for young people to focus on tasks for extended periods of time.\n\n\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'Social media and the Internet can make people feel anxious (e.g. about body image). One of the best ways to reduce this anxiety is...',
    type: 'select',
    answer:
      'Unplugging from the Internet at times (particularly after a certain time in the evening).',
  },

  /// Reporting concerns

  {
    question:
      'If something online is upsetting you or making you worried, who should be amongst the first people you should consider talking to?\n',
    type: 'select',
    answer: 'A parent / carer',
  },
  {
    question:
      "Teachers are only there to help you learn. You shouldn't tell them about things happening online that are worrying you.\n",
    type: 'select',
    answer: 'False',
  },
  {
    question: "\n\n\nYou should use 'click CEOP' if somebody is...\n\n\n",
    type: 'select',
    answer: 'doing any of the above',
  },
  {
    question:
      '\n\n\nYou can phone ChildLine any time of the day or night if you need to speak to somebody for support or advice.\n\n\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'ChildLine also have a one-to-one online text chat service you can use if you are uncomfortable talking to somebody over the phone.\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      '\n\n\nShout is a new service by text message providing support to...',
    type: 'select',
    answer: 'People in mental health crisis',
  },
  {
    question:
      '\n\n\nKooth provides free, safe and anonymous online support and even anonymous access to teams of friendly counsellors who are expert in providing mental health support. Who is this service aimed at?',
    type: 'select',
    answer: 'Young people',
  },
  {
    question:
      "When should you use the IWF/Childline service 'Report-Remove'?\n\n\n",
    type: 'select',
    answer:
      'If you need help to get a nude / part-nude image of yourself taken off the Internet.',
  },

  // AI

  {
    question: 'All Artificial Intelligence (AI) Systems are currently:\n',
    type: 'select',
    answer: 'Artificial Narrow Intelligence',
  },
  {
    question:
      'AI is already capable of thinking, learning and adapting in the way that humans do.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question: "How is generative AI 'trained'?",
    type: 'select',
    answer:
      'On huge datasets which include sources such as books, websites, social media posts, images, etc.',
  },
  {
    question:
      'A type of generative AI which can learn the complex patterns of human language and produce text outputs which are very human-like.\n',
    type: 'select',
    answer: 'Large Language Model',
  },
  {
    question:
      'An output from an AI model will be completely new. None of the component parts will have ever been seen before.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'Which of the following is NOT a benefit of generative AI enjoyed by businesses?',
    type: 'select',
    answer: 'Staff have shorter working days',
  },
  {
    question:
      'Using AI for decision-making ensures that your decisions are free from bias and based on accurate information.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'Using AI to help with your work ensures that you are using the most accurate and up-to-date information available.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'Sometimes generative AI creates ouputs which are not true and have been made up. These outputs are known as...',
    type: '',
    answer: 'Hallucinations',
  },
  {
    question:
      'When is it safe to enter personal information into a conversation with a chatbot?\n',
    type: 'select',
    answer: 'Never',
  },
  {
    question: 'Which statement is true?\n',
    type: 'select',
    answer: 'A prompt to a generative AI can be a complex set of instructions.',
  },
  {
    question: 'Which statement is true?\n',
    type: 'select',
    answer:
      'You can supply multiple prompts in a single conversation with a chatbot.',
  },
  {
    question:
      'Which of the following is NOT an important consideration you should make when choosing a chatbot?\n',
    type: 'select',
    answer: 'The quality of the logo design',
  },
  {
    question:
      'To use an AI chatbot as a tutor, you need to use an initial prompt which details the subject, your year group, the specific topic, etc. This important information is known as the...\n',
    type: 'select',
    answer: 'Context',
  },
  {
    question:
      'Summaries produced by generative AI mean that there is no longer any need to read chapters of books or watch videos that your teachers have requested.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'Which of the following is an appropriate use of AI, and will best support you to achieve the highest scores in assessments?\n',
    type: 'select',
    answer:
      'Using generative AI to come up with suggested essay plans to use as a road map.',
  },
  {
    question:
      'Which of the following is NOT an important part of a prompt to help you plan a presentation?\n',
    type: 'select',
    answer: 'Suggested animations',
  },
  {
    question:
      'You can rely on doing all your revision using multiple-choice questions created by generative AI.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'You can ask AI to generate a top-grade answer to a question and use the writing style and content to give you ideas on improving your work.\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      "You can copy and paste text directly from an answer generated by AI into your own work, as long as you properly reference it to show you didn't write it.\n",
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'You can copy and paste text directly from an answer generated by AI into your own work without referencing where it came from, as long as you wrote the original prompt.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'With regard to long-answer and essay questions, what would be the most appropriate way to start an interaction with an AI chatbot?\n',
    type: 'select',
    answer:
      'Ask it to help you plan the just structure for an essay, and then use it as a roadmap to share your thoughts and knowledge.',
  },
  {
    question:
      'Text-based chatbots like ChatGPT can only output text in paragraphs or bullet points. They cannot display text in tables.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question: 'Outputs from generative AI can be biased.\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'Outputs from generative AI can be incorrect, e.g. by being based on out-of-date information.\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'You should share personal information in your prompts to ensure the chatbot is able to really personalise the outputs it produces for you.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question:
      'Generative AI removes the need for you to learn the skills and content covered by your subjects at school.\n',
    type: 'select',
    answer: 'False',
  },
  {
    question: 'Which of the following statements is true?\n',
    type: 'select',
    answer:
      'If you submit AI-generated content in exam coursework, you must properly reference it or you could face serious consequences.',
  },
  {
    question:
      'You will get no marks for using AI-generated content in exam coursework, even if it is properly referenced.\n',
    type: 'select',
    answer: 'True',
  },
  {
    question:
      'Teachers are being trained in tools to help identify work that has been produced using AI chatbots.\n',
    type: 'select',
    answer: 'True',
  },
]
