async function solve() {
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    chrome.tabs.sendMessage(
      tabs[0].id,
      { command: 'solve' },
      function (response) {
        console.log(response)
      }
    )
  })
}

function record() {
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    chrome.tabs.sendMessage(
      tabs[0].id,
      { command: 'record' },
      /**
       *
       * @param {unknown} response
       */
      function (response) {
        if (
          typeof response === 'object' &&
          response &&
          'data' in response &&
          typeof response.data === 'object' &&
          response.data &&
          'msg' in response.data &&
          typeof response.data.msg === 'string' &&
          'clipboard' in response.data &&
          typeof response.data.clipboard === 'string'
        ) {
          navigator.clipboard.writeText(response.data.clipboard).then(() => {
            msg.innerHTML = response.data.msg
          })
        }
        console.log(response)
      }
    )
  })
}

function recordRes() {
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    chrome.tabs.sendMessage(
      tabs[0].id,
      { command: 'recordRes' },
      /**
       *
       * @param {unknown} response
       */
      function (response) {
        if (
          typeof response === 'object' &&
          response &&
          'data' in response &&
          typeof response.data === 'object' &&
          response.data &&
          'msg' in response.data &&
          typeof response.data.msg === 'string' &&
          'clipboard' in response.data &&
          typeof response.data.clipboard === 'string'
        ) {
          navigator.clipboard.writeText(response.data.clipboard).then(() => {
            msg.innerHTML = response.data.msg
          })
        }
        console.log(response)
      }
    )
  })
}

function finishPractice() {
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    chrome.tabs.sendMessage(
      tabs[0].id,
      { command: 'finishPractice' },
      function (response) {
        console.log(response)
      }
    )
  })
}

document.querySelector('#solve').onclick = solve
document.querySelector('#finishPractice').onclick = finishPractice
document.querySelector('#record').onclick = record
document.querySelector('#recordRes').onclick = recordRes

const advanced = document.querySelector('#advanced')
const advancedMenu = document.querySelector('#advancedMenu')
const msg = document.querySelector('#msg')

advanced.onclick = () => {
  advancedMenu.classList.toggle('hide')
}
